/*
 * PocketIME.h
 *
 * header file for PocketIME
 *
 * This wizard-generated code is based on code adapted from the
 * stationery files distributed as part of the Palm OS SDK 4.0.
 *
 * Copyright (c) 1999-2000 Palm, Inc. or its subsidiaries.
 * All rights reserved.
 */
 
#ifndef POCKETIME_H_
#define POCKETIME_H_

/*********************************************************************
 * Internal Structures
 *********************************************************************/

//бϢ
typedef struct
{
	Boolean			MBEnabled;			//Ƿ
	UInt32			MBDbType;			//type
	Boolean			inRAM;				//ڴ
	Char			file_name[32];		//ļ
}stru_MBList;

//ģϢ
typedef struct
{
	Char			key1[5];			//Ӧֵ1
	Char			key2[5];			//Ӧֵ2
	Boolean			actived;			//Ƿ񱻼
}stru_BlurInfo;

//Ϣ
typedef struct
{
	Boolean			enabled;			//
	Char			file_name[32];		//ļ
	UInt32			db_type;			//ļ
	Boolean			inRAM;				//ڴ
	Char			name[9];			//
	UInt8			type;				//
	UInt32			index_offset;		//ƫ
	UInt8			key_length;			//볤
	Char			used_char[30];		//ֵΧ
	Char			wild_char;			//ܼ
	UInt32			syncopate_offset;	//ȫԪƫ
	UInt32			syncopate_size;		//ȫԪߴ
	UInt32			translate_offset;	//ֵתƫ
	UInt32			translate_size;		//ֵתߴ
	UInt32			smart_offset;		//ģƫ
	UInt32			smart_size;			//ģߴ
	Boolean			gradually_search;	//
	Boolean			frequency_adjust;	//Ƶ
	Char			*key_syncopate;		//ԶϢ
	Char			*key_translate;		//ֵתϢ
	stru_BlurInfo	blur_head[11];		//ģ-ǰ
	stru_BlurInfo	blur_tail[11];		//ģ-
}stru_MBInfo;

#define FontGroup					2

//뷨Ϣ
typedef struct
{
	Boolean				Enabled;			//Ƿ뷨
	Boolean				Actived;			//뷨ǷԾ
	Int8				NotifyPriority;		//뷨ȼ
	
	RGBColorType		defaultCaretColor;	//ĬϹɫ
	UInt16				defaultKeyRate;		//ϵͳĬϰʱ
	
	UInt8				isTreo;				//ǷTreoϵ
	FontID				displayFont;		//ʾֵ
	UInt8				init_mode;			//Ĭʽ
	UInt8				last_mode;			//һ뷨״̬
	UInt16				init_mode_record;	//ǰ뷨״̬ļ¼
	FieldType			*current_field;		//ǰı
	Boolean				field_in_table;		//ǰıڱ
	
	UInt8				KBMode;				//ģʽ
	WChar				keyRange[2];		//ЧİΧ
	WChar				Selector[5];		//ѡְ
	WChar				Selector2[5];		//ڶѡְ
	WChar				IMESwitchKey;		//뷨״̬л
	WChar				KBMBSwitchKey;		//üģʽ-л
	WChar				MBSwitchKey;		//л
	WChar				TempMBSwitchKey;	//ʱл, һָֺԭ
	WChar				PuncKey;			//̼
	UInt8				PuncType;			//
	WChar				ListKey;			//б	
	WChar				SyncopateKey;		//
	WChar				MenuKey;			//˵
	WChar				JavaActiveKey;		//JavaDTG	
	Boolean				shouldShowfloatBar;	//ʾ
	Boolean				DTGSupport;			//֧Java
	Boolean				AutoMBSwich;		//֧Զл
	Boolean				LongPressMBSwich;	//л,Opt+л
	
	UInt8				activeStatus;		//״̬־
	Boolean				hasShiftMask;		//Shift־
	Boolean				hasOptionMask;		//Option־
	Boolean				isLongPress;		//ǳ
	Boolean				longPressHandled;	//򰴼¼Ѵ
	WinHandle			curWin;				//ǰ
	
	RGBColorType		caretColor;					//ɫ
	RGBColorType		frameColor;					//߿ɫ
	RGBColorType		codeForeColor;				//벿ǰɫ
	RGBColorType		codeBackColor;				//벿ֱɫ
	RGBColorType		resultForeColor;			//ǰɫ
	RGBColorType		resultBackColor;			//ֱɫ
	RGBColorType		resultHighlightForeColor;	//ָɫ
	RGBColorType		resultHighlightBackColor;	//ָɫ
	RGBColorType		chineseStatusColor;			//JavaDTG״̬£ָʾɫ
	RGBColorType		englishStatusColor;			//JavaDTG״̬£ָʾɫӢ
	
	RGBColorType		chineseEdgeColor;			//JavaDTG״̬£нǱԵɫ
	RGBColorType		englishEdgeColor;			//JavaDTG״̬£ӢнǱԵɫ
	
	UInt8				javaStatusStyle;			//JavaDTG״ָ̬ʾʽ
	UInt8				javaStatusStyleX;			//JavaDTG״ָ̬ʾʽĿ
	UInt8				javaStatusStyleY;			//JavaDTG״ָ̬ʾʽĸ߶
	
	Boolean				filterGB;			//ǷʾGB2312ַ
	Boolean				filterChar;			//Ƿʾ
	Boolean				dync_load;			//̬
	Boolean				english_punc;		//Ӣı
	Boolean				fullwidth;			//ȫǷ
	Boolean 			opt_fullwidth;		//opt+ǷҲȫ
	Boolean				num_fullwidth;		//ǷҪȫ
	Boolean				choice_button;		//ʾѡְť
	Boolean				menu_button;		//ʾ˵ť
	Boolean				keyDownDetected;	//⵽¼
	Boolean				suggestChar;		//Ƿ
	Boolean				altChar;			//Ƿַת
	Boolean				extractChar;		//ǷԴʶ
	Boolean 			autoSend;			//ǷԶ
	
	Boolean				onlyJavaModeShow;	//JavaģʽʾӢָʾ״̬
	Boolean				showGsi;			//ʾGSIָʾ
	
	stru_MBInfo			curMBInfo;			//ǰϢ
	
	Char				CustomLP[26][16];				//Զ峤
	Char				CustomLPPeriod[16];			//Զ峤
	Char				CustomLPShiftPeriod[16];	//ԶϷ
	Char				CustomLPOptBackspace[16];	//ԶϷ
	Char				CustomLPShiftBackspace[16];	//ԶϷ
}stru_Pref;

//Ӣ״̬Ϣ¼Ԫṹ
typedef struct
{
	UInt16			form_id;
	UInt16			object_count;
	UInt16			field_id;
	UInt8			mode;
}stru_InitInfo;
#define stru_InitInfo_length	8

//¼еݵԪ
typedef struct
{
	MemHandle		content;		//
	void			*next;			//һڵ
}stru_MBContent;
#define stru_MBContent_length	8

//¼еԪ
typedef struct
{
	UInt16			index;			//ֵ
	UInt16			offset;			//ƫ
	void			*next;			//һڵ
}stru_MBIndex;
#define stru_MBIndex_length		8

//ʽ
typedef struct
{
	Char			result[50];		//
	UInt16			length;			//
	UInt16			record_index;	//ڵļ¼
	Char			index[5];		//ֵ
	UInt16			offset;			//ڵļ¼ƫ
}stru_CreateWordResult;
//ߴ

//
typedef struct
{
	Char			*result;		//
	Char			*key;			// 볤4Ĳʻ뷨
	UInt16			length;			//
	UInt16			record_index;	//ڵļ¼
	Char			index[5];		//ֵ	
	Boolean			is_static;		//Ƿ̶
	UInt16			offset;			//ڵļ¼ƫ
	void			*next;			//һ
	void			*prev;			//һ
}stru_Result;
//ߴ
#define	stru_Result_length		26

//еƫ
typedef struct
{
	UInt16			key;				//ֵ
	UInt16			offset;				//ƫ
	void			*next;				//һ
}stru_ContentOffset;
//ߴ
#define	stru_ContentOffset_length	8

//
typedef struct
{
	Char				index[5];			//ü¼
	UInt16				record_index;		//ڵļ¼
	UInt16				last_word_length;	//һĳ
	Boolean				more_result_exist;	//нԼ
	stru_ContentOffset	offset_head;		//ƫıͷ
	stru_ContentOffset	offset_tail;		//ƫıβ
	void				*next;				//һ
	void				*prev;				//һ
}stru_MBRecord;
//ߴ
#define	stru_MBRecord_length		36

//ؼֻ浥Ԫ
typedef struct
{
	Char			content[100];		//ؼ
	UInt16			length;				//ؼֳ
}stru_KeyBufUnit;
#define stru_KeyBufUnit_length		102

//ؼֻ
typedef struct
{
	stru_KeyBufUnit	key[10];			//ؼֻ
	UInt16			key_index;			//ǰؼ
}stru_KeyBuf;

//ʱϢ
typedef struct
{
	Char					cache[512];			//ʱ

	Boolean					no_prev;			//ǷϷ
	Boolean					no_next;			//Ƿ·
	
	Boolean					in_create_word_mode;//ģʽ
	UInt8					created_word_count;	//ʻ
	UInt16					created_key;		//ʵ
	stru_CreateWordResult	created_word[10];	//ʻ
	
	stru_KeyBuf				key_buf;			//ؼֻ
	stru_KeyBufUnit			blur_key[5];		//ģؼ
	Boolean					new_key;			//½ؼֱ
	Boolean					english_mode;		//Ӣģʽ
	
	UInt16					current_word_length;//ǰ
	stru_MBRecord			*mb_record_head;	//ļ¼ѭıͷ
	stru_MBRecord			*mb_record;			//ļ¼ѭǰڵ
	stru_Result				result_head;		//ͷ
	stru_Result				result_tail;		//β
	stru_Result				*result;			//һЧڵ
	
	DmOpenRef				db_ref;				//ݿָ
	FileRef					db_file_ref;		//ݿָ루ϣ
	
	WinHandle				draw_buf;			//ͼ
	Boolean					in_menu;			//˵Ƿ񼤻
	
	UInt8					result_status[100];	//ÿҳĽʾ
	UInt8					page_count;			//ǰҳ
	UInt8					cursor;				//ǰѡ
	
	FormType				*imeFormP;
	MenuBarType				*imeMenuP;
	RectangleType			imeFormRectangle;
	stru_Pref				*settingP;
	WChar					initKey;
	Char					*bufP;
	
	RectangleType			resultRect[5];		//ѡ
	UInt8					curCharWidth;
	UInt8					curCharHeight;
	RectangleType			oneResultRect;
}stru_Globe;
//ȫֻߴ
#define	stru_Globe_length		2894

//ݼ¼
typedef struct
{
	MemHandle	recH;
	Char		*recP;
}stru_recData;
/*********************************************************************
 * Global variables
 *********************************************************************/


/*********************************************************************
 * Internal Constants
 *********************************************************************/

#define appFileCreator				'pIME'
#define appName						"PocketIME"
#define appVersionNum				0x01
#define appPrefID					0x00
#define appPrefVersionNum			0x05

#define sysAppLaunchCmdDALaunch			60000
#define sysAppLaunchCmdDALaunchJava			60001

#define PIME_CARD_PATH				"/PALM/Programs/PocketIME/"
#define PIME_CARD_PATH_DICT			"/PALM/Programs/PocketIME_Dict.pdb"

#define	ByteSwap16(n) ( ((((unsigned int) n) << 8) & 0xFF00) | ((((unsigned int) n) >> 8) & 0x00FF) )

#define ftrPrefNum					0x01				//ʱϢָ
#define ftrXplore					0x02				//ȨǼ̰¼

#define	frmIMEForm					0x1B58				//뷨ID
#define btnChr1						0x1B59
#define btnChr2						0x1B5A
#define btnChr3						0x1B5B
#define btnChr4						0x1B5C
#define btnChr5						0x1B5D
#define btnChrUP					0x1B5E
#define btnChrDOWN					0x1B5F
#define btnChrMENU					0x1B60
#define btnChrQ						0x1B61

#define frmAlt						0x1B62				//ϢID
#define lstAlt						0x1B63

#define	fixModeNormal				0x00				//Ƶģʽ-
#define fixModeTop					0x01				//Ƶģʽ-ǿƶһλ

#define	UP							0x00				//бԪƶ
#define DOWN						0x01				//бԪƶ

#define	LOAD						0x00				//
#define SAVE						0x01				//ж

#define GetTranslatedKey			0x00				//ֵת-ȡתļֵ
#define GetKeyToShow				0x01				//ֵת-ȡʾõļֵ

#define	unloadAll					0x00				//жȫڴĴ濨
#define unloadWithoutDefault		0x01				//жسĬⱻڴĴ濨

#define initDefaultChinese			0x00				//ʽ-Ĭ
#define initDefaultEnglish			0x01				//ʽ-ĬӢ
#define initKeepLast				0x02				//ʽ-״̬
#define initRememberFav				0x03				//ʽ-ס״̬

#define imeModeChinese				0x00				//뷨״̬-
#define imeModeEnglish				0x01				//뷨״̬-Ӣ

#define KBModeTreo					0x00				//ģʽ-Treo
#define KBModeExt					0x01				//ģʽ-ü
#define KBModeXplore				0x02				//ģʽ-ȨǼ
#define KBModeExtFull				0x03				//101

#define pchrZero					0x1920				//ȨǼֵ̼
#define pchrOne						0x1921
#define pchrTwo						0x1922
#define pchrThree					0x1923
#define pchrFour					0x1924
#define pchrFive					0x1925
#define pchrSix						0x1926
#define pchrSeven					0x1927
#define pchrEight					0x1928
#define pchrNine					0x1929
#define pchrAsterisk				0x192A
#define pchrNumberSign				0x192B
#define pchrBackspace				0x192C


#define isTreo600					0x01				//Treo豸ʶ-Treo 600
#define isTreo650					0x02				//Treo豸ʶ-Treo 650/680Centro

#define tempDisabledMask			0x01				//뷨״̬-Ӣ״̬
#define inJavaMask					0x02				//뷨״̬-JavaDTGģʽ
#define optActiveJavaMask			0x04				//뷨״̬-JavaDTG

#define tempMBSwitchMask			0x08				//ʱл״̬ - ʱ״̬

#define optionTempState				0x01				//Grfָʾ״̬
#define optionLockState				0x02
#define shiftTempState				0x03
#define shiftLockState				0x04

#define cursorLeft					0x00				//ƶ-
#define cursorRight					0x01				//ƶ-

#define slot1						0x01				//ҳλñʶ
#define slot2						0x02
#define slot3						0x04
#define slot4						0x08
#define slot5						0x10

#define SelectBySelector			0x00				//ѡģʽ-ѡּ
#define SelectByEnterKey			0x10				//ѡģʽ-س

#define pimeExit					0x00				//˳ʶ-˳
#define pimeCreateWord				0x01				//˳ʶ-˳󼤻ֶʽ
#define pimeReActive				0x02				//˳ʶ-˳ؽ¼
//#define pimeTempMB					0x03				//ʱ

#define NativeKeyDownEvent			0x0400				//¼Ϣеļ¼ֵ
#define NativeFldEnterEvent			0x0F00				//¼Ϣеı¼ֵ
//#define EventTypeSize				0x18				//¼ṹĳߴ

#define Style1						0x00				//JavaDTG״ָ̬ʾʽ
#define Style2						0x01				//JavaDTG״ָ̬ʾʽ
#define Style3						0x02				//JavaDTG״ָ̬ʾʽ
#define Style4						0x03				//JavaDTG״ָ̬ʾʽ

#define FORM_UPDATE_FRAMEONLY		0x0001

#define SUGGEST_LIST_HEIGHT			10					//б߶

#endif /* POCKETIME_H_ */
